//////////////////////////////////////////////////////////////
//     FILENAME :     USM01.js
//
//     CONTENTS :     This file contains objects to help enhance
//                    the navigation through sales manual documents.
//
//     EXTERNAL COMPONENTS :     This file needs the following
//                                   external components:
//                                        1)  USMTLS01.js
//
//     CREATED BY :     Richard C. Forrester IV  0x56066
//     CREATED ON :     October 02, 2002
//
//     UPDATED ON :     --
//////////////////////////////////////////////////////////////

// Local Variables
var app = new Application();                             // Application variable
var url = location.href;                                 // The current URL
var urlParse = new UrlParser(url);                       // URL Parser to break down the URL
var stylesheet = "<STYLE TYPE=\"text/css\">\n";          // Stylesheet variable to create dynamic stylesheet
var nBaseLen = url.indexOf("&sect=");                    // The length of the base url w/o parameters
var dispSect = null;                                     // The section to display when document is loaded
var curSectNo = 0;                                       // Current section number
var nextSect = 0;                                        // The next section number
var preSect = 0;                                         // The previsous section number
var sFooter = CreateFooter();                            // Creates the footer for the page

// Parse the url
urlParse.parse();

// Determine the base length of the url
if ( nBaseLen == -1 ) nBaseLen = url.length;

//if ( url.indexOf("ibmlink") != -1 )
//   stylesheet += "body { margin-left:10px; margin-top:10px; }\n";
//if ( url.indexOf("http") == -1 )
   stylesheet += "body { margin-left:10px; margin-top:10px; }\n";

var tmpCookie = app.getCookie("smprint");
if ( tmpCookie != null )
{
     tmpCookie.remove();
     window.onload = clearScreen;
}

// Close the dynamic stylesheet
stylesheet += "</STYLE>\n";

// Write stylesheet to the document
document.write(stylesheet);

//*********************************
// GENERIC FUNCTIONS

// Loads new window for printing
function SmanPrint()
{
     // extract the base url
     url = url.substring(0,nBaseLen);

     // Write cookie to determine if printing
     app.setCookie("smprint","true");

     // Open url in new window
     win = open(url);
}

// If running IE or NS 6.x and above.  This function will write the contents
// of the SmBody div tag into the body of the html document...removing all
// previous html and replacing it with just the Sales Manual contents. Then
// the document will print.
function clearScreen()
{
     // Determine if browser is NS 4.7 or anything else.
     if ( app.browser.isNS4 )
     {
          // Alert the user that printing will WYSIWIG and not a clean print
          var alertMsg = "You are currently using Netscape 4.7.  This document will print WYSIWYG.  ";
          alertMsg += "If you would like just the Sales Manual text to print. Please use Internet Explorer";
          alertMsg += " 5.5 or above or you can use Netscape 6.2 and above.";
          alert(alertMsg);
     }
     else
     {
          // Get the SmBody div tag element
          var elmnt = document.getElementById("SmBody");

          // Set the the body inner HTML to the SmBody inner HTML
          document.body.innerHTML = elmnt.innerHTML;
     }

     // Print the contents of the window
     window.print();

     // Have the window close after 5 seconds
     setTimeout("window.close();",5000);
}

// This function generates the HTML for the footer of the document
function CreateFooter()
{
     var scriptTxt = "<p>\n";
     scriptTxt += "&nbsp;\n";
     scriptTxt += "</p>\n";
     scriptTxt += "<a class=\"btt\" href=\"#top\"><img src=\"http://www-3.ibm.com/common/ssi/GIF/SMAN/U.GIF\" border=\"0\" align=\"absbottom\">Back \n";
     scriptTxt += "to top</a><br>\n";
     scriptTxt += "<img src=\"http://www.ibm.com/i/v11/rules/grey_rule.gif\" border=\"0\" height=\"1\" width=\"600\" alt=\"\" />\n";
     scriptTxt += "<br><table width=\"593\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
     scriptTxt += "     <tr>\n";
     scriptTxt += "          <td width=\"150\">\n";
     scriptTxt += "               <img src=\"http://www-3.ibm.com/common/ssi/GIF/SMAN/PRINT.GIF\" align=\"texttop\" width=\"14\" height=\"14\">\n";
     scriptTxt += "               <a class=\"nav\" href=\"javascript: SmanPrint();\">Printable version</a>\n";
     scriptTxt += "          </td>\n";
     scriptTxt += "     </tr>\n";
     scriptTxt += "</table>\n";

     return scriptTxt;
}

//-----------------------------  Object End --------------------------------------//
